-- Fact Invoice
select top 3
	InvoiceID
	, CustomerID
	, InvoiceDate
	, TotalDryItems
	, TotalChillerItems
	, getdate() as createDate
	, 'sreagin' as createdBy
	, getdate() as modifiedDate
	, 'sreagin' as modifiedBy
from
	WideWorldImporters.sales.Invoices

-- Fact Invoice Lines
select top 3
	i.InvoiceID
	, i.CustomerID
	, il.StockItemID
	, i.InvoiceDate
	, il.Quantity
	, il.UnitPrice
	, il.TaxRate
	, il.TaxAmount
	, il.LineProfit
	, il.ExtendedPrice
	, getdate() as createDate
	, 'sreagin' as createdBy
	, getdate() as modifiedDate
	, 'sreagin' as modifiedBy
from
	WideWorldImporters.sales.InvoiceLines il
	inner join WideWorldImporters.Sales.invoices i on
		i.InvoiceID = il.InvoiceID

-- Invoice
select
	dimI.invoiceSK
	, isnull(dimCu.customerSK, 0) as customerSK
	, i.InvoiceDate
	, i.TotalDryItems
	, i.TotalChillerItems
	, getdate() as createDate
	, 'sreagin' as createdBy
	, getdate() as modifiedDate
	, 'sreagin' as modifiedBy
from
	WideWorldImporters.sales.Invoices i
	inner join [PearsonLearning70-767].dbo.dimInvoice dimI on dimI.invoiceID = i.InvoiceID and dimI.obsoleteDate is null
	left outer join [PearsonLearning70-767].dbo.dimCustomer dimCu on dimCu.CustomerID = i.customerID and dimCu.obsoleteDate is null

-- Invoice Lines
select
	dimI.invoiceSK
	, isnull(dimCu.customerSK, 0) as customerSK
	, isnull(dimP.productSK, 0) as productSK
	, i.InvoiceDate
	, il.Quantity
	, il.UnitPrice
	, il.TaxRate
	, il.TaxAmount
	, il.LineProfit
	, il.ExtendedPrice
	, getdate() as createDate
	, 'sreagin' as createdBy
	, getdate() as modifiedDate
	, 'sreagin' as modifiedBy
from
	WideWorldImporters.sales.InvoiceLines il
	inner join WideWorldImporters.sales.Invoices i on i.InvoiceID = il.invoiceID
	inner join [PearsonLearning70-767].dbo.dimInvoice dimI on dimI.invoiceID = i.InvoiceID and dimI.obsoleteDate is null
	inner join [PearsonLearning70-767].dbo.dimCustomer dimCu on dimCu.CustomerID = i.customerID and dimCu.obsoleteDate is null
	inner join [PearsonLearning70-767].dbo.dimProduct dimP on dimP.stockItemID = il.stockItemID
		and i.InvoiceDate between dimI.effectiveDate and isnull(dimI.obsoleteDate, i.InvoiceDate)

